/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.periph.joystick;

import frc.emul.api.IDevice;
import frc.emul.api.IDeviceEvent;
import frc.emul.api.IDeviceEventManager;
import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemController;
import frc.emul.config.data.CfgItemCurve;
import frc.emul.config.data.CfgItemSensitivity;
import frc.emul.periph.IPeripheral;
import frc.emul.periph.misc.AbstractDevice;
import frc.emul.util.AttributesMap;
import frc.emul.util.maths.MathUtils;
import frc.input.JInputComponent;
import frc.input.JInputController;
import frc.input.JInputManager;
import java.awt.Component;
import java.awt.event.InputEvent;

public final class JInputJoystick
extends AbstractDevice
implements IDevice,
IPeripheral.FrameHandler {
    public static final String NAME = "Controller";
    public static final String ATTR_CONTROLLER_ID = "controller";
    private static final int CALIBRATION_RESOLUTION = 4096;
    private final IDeviceEventManager evtMgr;
    private final AttributesMap attrs;
    private JInputController ctrl;
    private String ctrlID;
    private CfgItemController.DirControl dirMode;
    private float compSignX;
    private float compSignY;
    private float compSensitivityX;
    private float compSensitivityY;
    private JInputComponent compAxisX;
    private JInputComponent compAxisY;
    private JInputComponent compAxisU;
    private JInputComponent compAxisD;
    private JInputComponent compAxisL;
    private JInputComponent compAxisR;
    private JInputComponent compAxisPov;
    private JInputComponent compBtn1;
    private JInputComponent compBtn2;
    private JInputComponent compBtn3;
    private JInputComponent compBtn4;
    private int buttons;
    private int axisX;
    private int axisY;
    private float rawX;
    private float rawY;
    private float accuX;
    private float accuY;
    private boolean polling;
    private boolean needsPolling;
    private float[] calibration;

    public static final JInputJoystick createDevice(JInputController jInputController, CfgItemController cfgItemController) {
        return new JInputJoystick(jInputController, cfgItemController);
    }

    public static final IDevice createDevice(int n, IDeviceEventManager iDeviceEventManager, AttributesMap attributesMap) {
        String string = (String)attributesMap.get(ATTR_CONTROLLER_ID);
        if (string == null) {
            throw new RuntimeException("No mapped controller ID specified!");
        }
        if (JInputManager.getDefaultManager().getController(string) == null) {
            System.out.println("*** WARNING : Cannot find any controller with ID \"" + string + "\" ... (not connected?)");
            iDeviceEventManager.fireEvent(n, IDeviceEvent.Cause.ERROR_CONTROLLER_NOT_CONNECTED, "Cannot find the device that was previously plugged in port #" + (n + 1) + ".");
            return null;
        }
        return new JInputJoystick(iDeviceEventManager, attributesMap);
    }

    public JInputJoystick(IDeviceEventManager iDeviceEventManager, AttributesMap attributesMap) {
        this.attrs = attributesMap;
        this.evtMgr = iDeviceEventManager;
        this.setResponse(null);
        this.setSensitivity(null);
    }

    private JInputJoystick(JInputController jInputController, CfgItemController cfgItemController) {
        this.attrs = null;
        this.evtMgr = null;
        this.gatherConfiguration(jInputController, cfgItemController);
        this.setActivated(true);
    }

    public final String toString() {
        return "Controller " + (this.attrs != null ? (String)this.attrs.get(ATTR_CONTROLLER_ID) : this.ctrlID);
    }

    public AttributesMap getAttributes() {
        return this.attrs;
    }

    public final void handleNewFrame() {
        this.poll();
    }

    public String getID() {
        return "CONTROLLER";
    }

    public String getName() {
        return NAME;
    }

    public void applyConfiguration(Configuration configuration, int n) {
        this.gatherConfiguration(configuration);
    }

    public void plug(Component component, int n) {
        this.setActivated(this.ctrl != null);
    }

    public void unplug(Component component, int n) {
        this.setActivated(false);
    }

    public final boolean consumes(InputEvent inputEvent) {
        return false;
    }

    public final int getButtonsState() {
        if (this.needsPolling) {
            this.pollImpl();
        }
        return this.buttons;
    }

    public final int getAnalogX() {
        if (this.needsPolling) {
            this.pollImpl();
        }
        return this.axisX;
    }

    public final int getAnalogY() {
        if (this.needsPolling) {
            this.pollImpl();
        }
        return this.axisY;
    }

    public final boolean isRelativeX() {
        return this.isAxisMapped() && this.compAxisX.isRelative();
    }

    public final boolean isRelativeY() {
        return this.isAxisMapped() && this.compAxisY.isRelative();
    }

    public final boolean isAnalogX() {
        return this.isAxisMapped() && this.compAxisX.isAnalog();
    }

    public final boolean isAnalogY() {
        return this.isAxisMapped() && this.compAxisY.isAnalog();
    }

    public final float getRawAnalogX() {
        return this.isAxisMapped() ? this.rawX : (float)(this.axisX / 127);
    }

    public final float getRawAnalogY() {
        return this.isAxisMapped() ? this.rawY : (float)(this.axisY / 127);
    }

    public final boolean isAxisMapped() {
        return this.dirMode == CfgItemController.DirControl.AXIS;
    }

    public final void setResponse(CfgItemCurve cfgItemCurve) {
        float[] fArray = this.calibration;
        if (fArray == null) {
            this.calibration = fArray = new float[4096];
        }
        if (cfgItemCurve == null || !cfgItemCurve.isActive() || cfgItemCurve.getPoints().isEmpty()) {
            int n = fArray.length;
            while (n-- > 0) {
                fArray[n] = (float)n / (float)(fArray.length - 1);
            }
        } else {
            MathUtils.fillCatmullRom(cfgItemCurve.getPoints(), fArray, 5.0f);
        }
    }

    public final void setSensitivity(CfgItemSensitivity cfgItemSensitivity) {
        this.compSensitivityX = cfgItemSensitivity == null ? 1.0f : cfgItemSensitivity.axisX;
        this.compSensitivityY = cfgItemSensitivity == null ? 1.0f : cfgItemSensitivity.axisY;
    }

    public final float[] getCalibrationLookupTable() {
        return this.calibration;
    }

    public final void poll() {
        this.needsPolling = true;
    }

    private final void setActivated(boolean bl) {
        this.buttons = 15;
        this.axisX = 0;
        this.axisY = 0;
        this.rawX = 0.0f;
        this.rawY = 0.0f;
        this.accuX = 0.0f;
        this.accuY = 0.0f;
        this.polling = bl;
        this.needsPolling = true;
    }

    private final void pollImpl() {
        this.needsPolling = false;
        if (this.polling) {
            if (!this.ctrl.poll()) {
                this.error("*** Cannot poll controller \"" + this.ctrlID + "\"", null);
            } else {
                try {
                    int n = 15;
                    if (this.compBtn1.getData() != 0.0f) {
                        n &= 0xFFFFFFFE;
                    }
                    if (this.compBtn2.getData() != 0.0f) {
                        n &= 0xFFFFFFFD;
                    }
                    if (this.compBtn3.getData() != 0.0f) {
                        n &= 0xFFFFFFFB;
                    }
                    if (this.compBtn4.getData() != 0.0f) {
                        n &= 0xFFFFFFF7;
                    }
                    this.buttons = n;
                    block1 : switch (this.dirMode) {
                        case AXIS: {
                            if (this.compAxisX.isRelative()) {
                                this.accuX += this.compSensitivityX * this.compAxisX.getData();
                                if (this.accuX > 127.0f) {
                                    this.accuX = 127.0f;
                                } else if (this.accuX < -127.0f) {
                                    this.accuX = -127.0f;
                                }
                                this.rawX = this.compSignX * this.accuX / 127.0f;
                            } else {
                                this.rawX = this.compSignX * this.compAxisX.getData();
                            }
                            if (this.compAxisY.isRelative()) {
                                this.accuY += this.compSensitivityY * this.compAxisY.getData();
                                if (this.accuY > 127.0f) {
                                    this.accuY = 127.0f;
                                } else if (this.accuY < -127.0f) {
                                    this.accuY = -127.0f;
                                }
                                this.rawY = this.compSignY * this.accuY / 127.0f;
                            } else {
                                this.rawY = this.compSignY * -this.compAxisY.getData();
                            }
                            int n2 = (int)(this.rawX * 4095.0f);
                            int n3 = (int)(this.rawY * 4095.0f);
                            this.axisX = (int)(127.0f * (n2 >= 0 ? this.calibration[n2] : -this.calibration[-n2]));
                            this.axisY = (int)(127.0f * (n3 >= 0 ? this.calibration[n3] : -this.calibration[-n3]));
                            break;
                        }
                        case BTNS: {
                            this.axisX = 127 * (int)this.compAxisR.getData() - 127 * (int)this.compAxisL.getData();
                            this.axisY = 127 * (int)this.compAxisU.getData() - 127 * (int)this.compAxisD.getData();
                            break;
                        }
                        case POV: {
                            switch ((int)(1000.0f * this.compAxisPov.getData())) {
                                case 125: {
                                    this.axisX = -127;
                                    this.axisY = 127;
                                    break block1;
                                }
                                case 250: {
                                    this.axisX = 0;
                                    this.axisY = 127;
                                    break block1;
                                }
                                case 375: {
                                    this.axisX = 127;
                                    this.axisY = 127;
                                    break block1;
                                }
                                case 500: {
                                    this.axisX = 127;
                                    this.axisY = 0;
                                    break block1;
                                }
                                case 625: {
                                    this.axisX = 127;
                                    this.axisY = -127;
                                    break block1;
                                }
                                case 750: {
                                    this.axisX = 0;
                                    this.axisY = -127;
                                    break block1;
                                }
                                case 875: {
                                    this.axisX = -127;
                                    this.axisY = -127;
                                    break block1;
                                }
                                case 1000: {
                                    this.axisX = -127;
                                    this.axisY = 0;
                                    break block1;
                                }
                            }
                            this.axisX = 0;
                            this.axisY = 0;
                        }
                    }
                }
                catch (Exception exception) {
                    this.error("*** Exception while polling controller \"" + this.ctrlID + "\"", exception);
                }
            }
        }
    }

    private final boolean gatherConfiguration(Configuration configuration) {
        this.ctrlID = (String)this.attrs.get(ATTR_CONTROLLER_ID);
        if (this.ctrlID == null) {
            throw new RuntimeException("No mapped controller ID specified!");
        }
        JInputManager jInputManager = JInputManager.getDefaultManager();
        JInputController jInputController = jInputManager.getController(this.ctrlID);
        if (jInputController == null) {
            System.out.println("*** Cannot find controller " + this.ctrlID);
            return false;
        }
        CfgItemController cfgItemController = configuration.getController(this.ctrlID);
        if (cfgItemController == null) {
            cfgItemController = jInputController.getDefaults();
        }
        return this.gatherConfiguration(jInputController, cfgItemController);
    }

    private final boolean gatherConfiguration(JInputController jInputController, CfgItemController cfgItemController) {
        this.ctrl = jInputController;
        this.ctrlID = jInputController.getID();
        this.dirMode = cfgItemController.dirMode;
        switch (this.dirMode) {
            case AXIS: {
                this.compAxisX = jInputController.getNonNullComponent(cfgItemController.axisXID);
                this.compAxisY = jInputController.getNonNullComponent(cfgItemController.axisYID);
                this.compSignX = cfgItemController.invertX ? -1.0f : 1.0f;
                this.compSignY = cfgItemController.invertY ? -1.0f : 1.0f;
                break;
            }
            case BTNS: {
                this.compAxisU = jInputController.getNonNullComponent(cfgItemController.upID);
                this.compAxisD = jInputController.getNonNullComponent(cfgItemController.downID);
                this.compAxisL = jInputController.getNonNullComponent(cfgItemController.leftID);
                this.compAxisR = jInputController.getNonNullComponent(cfgItemController.rightID);
                break;
            }
            case POV: {
                this.compAxisPov = jInputController.getNonNullComponent(cfgItemController.povID);
                break;
            }
            case UNDEFINED: {
                System.out.println("Cannot handle controller " + this.ctrlID);
                return false;
            }
        }
        this.compBtn1 = jInputController.getNonNullComponent(cfgItemController.buttonID[0]);
        this.compBtn2 = jInputController.getNonNullComponent(cfgItemController.buttonID[1]);
        this.compBtn3 = jInputController.getNonNullComponent(cfgItemController.buttonID[2]);
        this.compBtn4 = jInputController.getNonNullComponent(cfgItemController.buttonID[3]);
        this.setResponse(cfgItemController.response);
        this.setSensitivity(cfgItemController.sensitivity);
        return true;
    }

    private final void error(String string, Exception exception) {
        this.setActivated(false);
        System.out.println(string);
        if (exception != null) {
            exception.printStackTrace();
        }
        if (this.evtMgr == null) {
            return;
        }
        String string2 = this.ctrl != null ? this.ctrl.getName() : this.ctrlID;
        this.evtMgr.fireEvent(this, IDeviceEvent.Cause.ERROR_CONTROLLER_POLL_FAILURE, "Failed to poll the controller \"" + string2 + "\"");
    }
}

